#define DelegateCreate
/*
    Funkcja: DelegateCreate()
    
    Zwraca:  ID Delegacji

    Opis:    Tworzy nowa delegacje (kontener delegatow w formie specjalnej listy)
*/


    if ( !variable_global_exists( "DL_Initiated" ) )
    {
        global.DL_Initiated  = true;

        global.DL_EventId         = 1;                  // Z tej zmiennej beda przydzielane unikatowe kluczenia dla delegatow
        global.DL_EventDelegate   = ds_map_create();    // klucz ID delegata -> ID delegacji (do wyszukiwania delegacji przy usuwaniu delegata)
        global.DL_ObjectDelegates = ds_map_create();    // klucz ID obiektu ds_list z ID delegacji (do usuwania wszystkich delegatow obiektu)
        global.DL_Delegates       = ds_list_create();   // Lista wszystkich delegacji

        global.DL_ID              = 0;                  // Obiekt dla ktorego wywolujemy delegacje
        global.DL_VID             = 0;                  // Numer skryptu czy event_usera

        global.DL_Sender          = noone;              // Obiekt, ktory wywolal delegacje
        global.DL_Params          = 0;                  // Tablica argumentow przekazanych przy wywolywaniu delegacji
    }

    var _ds;
    _ds = ds_list_create();
    ds_list_add( _ds, ds_list_create() );               // unikatowy klucz ID delegata
    ds_list_add( _ds, ds_list_create() );               // ID obiektu, dla ktorego delegat "pracuje"
    ds_list_add( _ds, ds_list_create() );               // numer skryptu / event_user

    ds_list_add( global.DL_Delegates, _ds );
 
    return _ds;
#define DelegateDestroy
/*
    Funkcja: DelegateDestroy( ID delegacji )
    
    Arg0:    ID delegacji (kontenera delegatow)

    Zwraca:  true / false w zaleznosci czy operacja sie powiodla ( czy delegacja istniala )
    Opis:    Niszczy delegacje (wczesniej ja czyszczac)
*/
    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;

    DelegateClear( argument[0] );


/*
 *  Usuwamy podlisty i liste delegacji
 */
    ds_list_destroy( ds_list_find_value( argument[0], 0 ) );
    ds_list_destroy( ds_list_find_value( argument[0], 1 ) );
    ds_list_destroy( ds_list_find_value( argument[0], 2 ) );

    ds_list_destroy( argument[0] );

/*
 *  Usuwamy delegacje z listy delegacji
 */
    var _dp;

    _dp = ds_list_find_index( global.DL_Delegates, argument[0] );
    ds_list_delete( global.DL_Delegates, _dp );

    return true;
#define DelegateAddEvent
/*
    Funkcja: DelegateAddEvent( ID delegacji, Numer event_user, ID obiektu eventa )
    
    Arg0:    ID delegacji (kontenera delegatow)
    Arg1:    Numer event_user'a
    Arg2:    ID obiektu, ktoremu zostanie wywolany event_user (przy wywolaniu DelegateCall)
    
    Zwraca:  Unikatowe ID Delegata lub false gdy nie ma docelowej delegacji

    Opis:    Dodaje do delegacji nowego delegata typu event user
*/
    var _id, _eKey;

    if ( instance_exists( argument[2] ) )
        _id = argument[2];
    else
        show_error( "DelegateAddEvent, Arg2: Nie ma obiektu o ID "+string( argument[2] ), true );

    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;

    _eKey = global.DL_EventId;
    global.DL_EventId += 1;


/*
 *  Rejestrujemy klucz zdarzenie -> delegacja
 */
    ds_map_add( global.DL_EventDelegate, _eKey, argument[0] );


/*
 *  Rejestrujemy klucz obiekt -> lista delegacji, w ktorych ma delegata
 */
    var _dl;
 
    if ( ds_map_exists( global.DL_ObjectDelegates, _id ) )
    {
        _dl = ds_map_find_value( global.DL_ObjectDelegates, _id );

        if ( ds_list_find_index( _dl, argument[0] ) == -1 )
            ds_list_add( _dl, argument[0] );
    }
    else
    {
        _dl = ds_list_create();
        ds_list_add( _dl, argument[0] );
        ds_map_add( global.DL_ObjectDelegates, _id, _dl );
    }


/*
 *  Rejestrujemy delegata we wlasciwej delegacji
 */
    var _d1, _d2, _d3;

    _d1 = ds_list_find_value( argument[0], 0 );
    _d2 = ds_list_find_value( argument[0], 1 );
    _d3 = ds_list_find_value( argument[0], 2 );

    ds_list_add( _d1, _eKey );
    ds_list_add( _d2, _id );
    ds_list_add( _d3, ( argument[1] * -1 ) - 1 );

    return _eKey;
#define DelegateAddScript
/*
    Funkcja: DelegateAddScript( ID delegacji, ID skryptu, ID obiektu wywolujacego skrypt )
    
    Arg0:    ID delegacji (kontenera delegatow)
    Arg1:    Numer skryptu
    Arg2:    ID obiektu, ktoremu zostanie wywolany skrypt (przy wywolaniu DelegateCall)
    
    Zwraca:  Unikatowe ID Delegata lub false gdy nie ma takiej delegacji

    Opis:    Dodaje do delegacji nowego delegata typu skrypt
*/
    var _id, _eKey;

    if ( instance_exists( argument[2] ) )
        _id = argument[2];
    else
        show_error( "DelegateAddEvent, Arg2: Nie ma obiektu o ID "+string( argument[2] ), true );

    if ( !script_exists( argument[1] ) )
        show_error( "DelegateAddEvent, Arg1: Nie ma skryptu o ID "+string( argument[1] ), true );

    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;

    _eKey = global.DL_EventId;
    global.DL_EventId += 1;


/*
 *  Rejestrujemy klucz zdarzenie -> delegacja
 */
    ds_map_add( global.DL_EventDelegate, _eKey, argument[0] );


/*
 *  Rejestrujemy klucz obiekt -> lista delegacji, w ktorych ma delegata
 */
    var _dl;
 
    if ( ds_map_exists( global.DL_ObjectDelegates, _id ) )
    {
        _dl = ds_map_find_value( global.DL_ObjectDelegates, _id );

        if ( ds_list_find_index( _dl, argument[0] ) == -1 )
            ds_list_add( _dl, argument[0] );
    }
    else
    {
        _dl = ds_list_create();
        ds_list_add( _dl, argument[0] );
        ds_map_add( global.DL_ObjectDelegates, _id, _dl );
    }


/*
 *  Rejestrujemy delegata we wlasciwej delegacji
 */
    var _d1, _d2, _d3;

    _d1 = ds_list_find_value( argument[0], 0 );
    _d2 = ds_list_find_value( argument[0], 1 );
    _d3 = ds_list_find_value( argument[0], 2 );

    ds_list_add( _d1, _eKey );
    ds_list_add( _d2, _id );
    ds_list_add( _d3, argument[1] );

    return _eKey;
#define DelegateDelete
/*
    Funkcja: DelegateDelete( Unikatowe ID Delegata )

    Arg0:    unikatowe ID delegata do usuniecia z delegacji (delegacja zawierajaca tego delegeta zostanie automatycznie znaleziona)

    Zwraca:  true / false zaleznie od powodzenia operacji (false np. gdy nie ma takiego delegata)

    Opis:    Usuwa z delegacji delegata o okreslonym ID
*/

    var _do, _d1, _d2, _d3, _dp, _id, _d4;

    if ( !ds_map_exists( global.DL_EventDelegate, argument[0] ) )
        return false;

/*
 *  Pobieramy delegacje delegata i usuwamy klucz delegat -> delegacja z listy wszystkich delegatow
 */
    _do = ds_map_find_value( global.DL_EventDelegate, argument[0] );
    ds_map_delete( global.DL_EventDelegate, argument[0] );

/*
 *  Usuwamy delegata z delegacji, przy okazji pobierajac id obiektu wlasciciela
 */
    _d1 = ds_list_find_value( _do, 0 );
    _d2 = ds_list_find_value( _do, 1 );
    _d3 = ds_list_find_value( _do, 2 );

    _dp = ds_list_find_index( _d1, argument[0] );
    _id = ds_list_find_value( _d2, _dp );

    ds_list_delete( _d1, _dp );
    ds_list_delete( _d2, _dp );
    ds_list_delete( _d3, _dp );
    
/*
 *  Sprawdzamy czy to byl ostatni delegat obiektu w danej delegacji, jesli tak to usuwamy klucz obiekt -> delegacja
 */
    if ( ds_list_find_index( _d2, _id ) == -1 )
    {
        _d4  = ds_map_find_value( global.DL_ObjectDelegates, _id );
        ds_list_delete( _d4, ds_list_find_index( _d4, _do ) );

        if ( ds_list_empty( _d4 ) )
        {
            ds_list_destroy( _d4 );
            ds_map_delete( global.DL_ObjectDelegates, _id );
        }
    }

    return true;
#define DelegateDeleteAll
/*
    Funkcja: DelegateDelete( ID obiektu )

    Arg0:    ID obiektu lub nazwa typu obiektu

    Zwraca:  true / false w zaleznosci czy znaleziono jakies delegaty danego obiektu

    Opis:    Usuwa wszystkie delegaty, ktorych wlascicielem jest dany obiekt
*/
    var _v, _did, _d1, _d2, _dp, _did2;

    if (  !ds_map_exists( global.DL_ObjectDelegates, argument[0] ) )
        return false;


/*
 *  Pobieramy liste delegacji, z ktorymi zadany obiekt jest powiazany i powtarzamy czyszczenie delegacji z delegatow obiektu
 */
    _v = ds_map_find_value( global.DL_ObjectDelegates, argument[0] );

    repeat( ds_list_size( _v ) )
    {
        _did = ds_list_find_value( _v, 0 );

        _d1  = ds_list_find_value( _did, 0 );
        _d2  = ds_list_find_value( _did, 1 );  
 
        _dp  = ds_list_find_index( _d2 , argument[0] );
        while ( _dp != -1 )
        {
            _did2 = ds_list_find_value( _d1, _dp );
            DelegateDelete( _did2 );
            _dp  = ds_list_find_index( _d2 , argument[0] );
        }
    }

    return true;
#define DelegateClear
/*
    Funkcja: DelegateClear( ID delegacji )
    
    Arg0:    ID delegacji (kontenera delegatow)

    Zwraca:  true / false w zaleznosci czy operacja sie powiodla ( czy delegacja istniala )

    Opis:    Usuwa z delegacji wszystkich delegatow
*/

    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;

    var _d1;

    _d1 = ds_list_find_value( argument[0], 0 );

    repeat( ds_list_size( _d1 ) )
    {
        DelegateDelete( ds_list_find_value( _d1, 0 ) );
    }

    return true;
#define DelegateSize
/*
    Funkcja: DelegateSize( ID delegacji )
    
    Arg0:    ID delegacji (kontenera delegatow)

    Zwraca:  Liczbe delegatow w delegacji lub false gdy nie ma zadanej delegacji

    Opis:    Zwraca liczbe delegatow w delegacji
*/

    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;

    var _d1;
    _d1 = ds_list_find_value( argument[0], 0 );
    return ds_list_size( _d1 );
#define DelegateCall
/*
    Funkcja: DelegateCall( ID delegacji, argumenty dla zdarzen )
    
    Arg0:    ID delegacji, ktorej delegaty zostana wywolane
    Arg2-15: Argumenty opcjonalne, ktore zostana przekazane do skryptow

    Zwraca:  true / false zeleznie od powodzenia (czy dana delegacja w ogole istnieje)

    Opis:    Wywoluje wszystkie delegaty obiektow ( event_usery i skrypty, ktore dodalismy do delegacji)

             Dla kazdego delegata beda dostepne dwie zmienne:
             global.DL_Sender   - ID obiektu, ktory wywolal delegacje (np w celu pobrania jego wartosci lokalnych)
             global.DL_Params   - Argumenty dla zdarzen, ktore zostaly przekazane przy wywolywaniu delegacji

             Po wywolaniu zdarzen i skryptow global.DL_Sender i global.DL_Params sa czyszczone.
*/

    if ( ds_list_find_index( global.DL_Delegates, argument[0] ) == -1 )
        return false;


/*
 *  Ustawiamy zmienne globalne jako specjalne parametry
 */
    var _i, _d1, _d2;

    global.DL_Sender = id;

    _i = 0;
    repeat( 14 )
    {
        global.DL_Params[_i] = argument[_i+1];
        _i += 1;
    }

    _d1 = ds_list_find_value( argument[0], 1 );
    _d2 = ds_list_find_value( argument[0], 2 );

    _i = 0;
    repeat ( ds_list_size( _d1 ) )
    {
        global.DL_ID   = ds_list_find_value( _d1, _i );
        global.DL_VID  = ds_list_find_value( _d2, _i );
        _i += 1;

        if ( global.DL_VID > 0 )
        {
            with ( global.DL_ID )
            {
                script_execute( global.DL_VID, argument1, argument2, argument3, argument4, argument5, argument6, argument7, argument8, argument9,
                                argument10, argument11, argument12, argument13, argument14, argument15 );
            }
        }
        else
        {
            global.DL_VID = abs( global.DL_VID ) - 1;
            with( global.DL_ID )
            {
                event_user( global.DL_VID );
            }
        }
    }

    global.DL_Sender = noone;

    _i = 0;
    repeat( 14 )
    {
        global.DL_Params[_i] = 0;
        _i += 1;
    }

    global.DL_ID   = noone;
    global.DL_VID  = 0;

    return true;
#define DelegateDrawDebugger
/*
    Funkcja: DelegateDebuggerDraw()

    Opis:    Rysowanie debuggera dla systemu delegacji
*/


if ( !variable_global_exists( "DL_Initiated" ) )
    exit;

draw_text( 10, 10, "DL_EventId: "+ string( global.DL_EventId ) + " (kolejny unikatowy ID delegata)" );
draw_text( 10, 20, "DL_EventDelegate: " + string( ds_map_size( global.DL_EventDelegate ) ) + " (liczba elementow)" );

var _i, _j, _z, _k, _v, _k2, _v2, _d1, _d2, _d3;

_i = 1;

if ( !ds_map_empty( global.DL_EventDelegate ) )
{
    _k = ds_map_find_first( global.DL_EventDelegate );


    while ( _k > 0 )
    {
        _v = ds_map_find_value( global.DL_EventDelegate, _k );
        draw_text( 50, 20 + _i * 10, "-> delegat ID: "+string( _k )+", delegacja ID: "+string( _v ) );
        _k = ds_map_find_next( global.DL_EventDelegate, _k );
        _i += 1;
    }
}

_i += 1;
draw_text( 10, 20 + _i * 10, "DL_ObjectDelegates: " + string( ds_map_size( global.DL_ObjectDelegates ) ) + " (liczba elementow)" );
_i += 1;

if ( !ds_map_empty( global.DL_ObjectDelegates ) )
{
    _k = ds_map_find_first( global.DL_ObjectDelegates );

    while ( _k > 0 )
    {
        _v = ds_map_find_value( global.DL_ObjectDelegates, _k );
        draw_text( 50, 20 + _i * 10, "-> Obiekt ID: "+string( _k )+", delegacje: "+string( ds_list_size( _v ) ) );
        
        if ( !ds_list_empty( _v ) )
        {
            _j = 0;
            repeat( ds_list_size( _v ) )
            {
                _i += 1;
                draw_text( 100, 20 + _i * 10, "Delegacja ID: "+ string ( ds_list_find_value( _v, _j ) ) );
                _j += 1;
            }
        }

        _k = ds_map_find_next( global.DL_ObjectDelegates, _k );
        _i += 1;
    }
}

_i += 1;

draw_text( 10, 20 + _i * 10, "DL_Delegates (liczba utworzonych delegacji): " + string( ds_list_size( global.DL_Delegates ) ) );
_i += 1;

if ( !ds_list_empty( global.DL_Delegates ) )
{
    _j = 0;
    repeat( ds_list_size( global.DL_Delegates ) )
    {
        _v = ds_list_find_value( global.DL_Delegates, _j );
        _d1 = ds_list_find_value( _v, 0 );
        _d2 = ds_list_find_value( _v, 1 );
        _d3 = ds_list_find_value( _v, 2 );
        draw_text( 50, 20 + _i * 10, "-> Delegacja ID: "+ string ( _v )+", delegatow: "+string( ds_list_size( _d1 ) ) );
        _i += 1;
        
        _z = 0;
        repeat ( ds_list_size( _d1 ) )
        {
            _v2 = ds_list_find_value( _d3, _z );
            if ( _v2 < 0 )
                _k2 = ", Event User "+string( abs(_v2)-1 );
            else
                _k2 = ", Skrypt: "+string( script_get_name( _v2 ) );

            draw_text( 100, 20 + _i * 10, "Delegat ID: "+string(ds_list_find_value(_d1,_z))+", Obiekt ID: "+string(ds_list_find_value(_d2,_z))+_k2 ); 
            _i += 1;
            _z += 1;
        
        }
        _j += 1;
    
    }
}
draw_set_color( c_black );

